/*:
 * @plugindesc エロステータス画面を簡単に呼び出せるプラグイン
 * @author Anthropic AI
 *
 * @help
 * 右クリックまたはスペースキーでエロステータス画面を表示/非表示できます。
 * イベント中からもエロステータス画面を呼び出せます。
 * 画面表示中はイベントが一時停止します。
 */

(function() {
    var _Game_Interpreter_prototype_update = Game_Interpreter.prototype.update;
    Game_Interpreter.prototype.update = function() {
        // エロステータス画面表示中はイベントを一時停止
        if ($gameSystem.isEroStatusActive()) {
            return;
        }
        _Game_Interpreter_prototype_update.call(this);
    };

    var _Game_Interpreter_prototype_command355 = Game_Interpreter.prototype.command355;
    Game_Interpreter.prototype.command355 = function() {
        // イベントコマンド【スクリプト】からエロステータスを呼び出す
        if (this.isEroStatusCommand()) {
            $gameSystem.setEroStatusActive(true);
            SceneManager.push(Scene_EroStatus);
            return true;
        }
        return _Game_Interpreter_prototype_command355.call(this);
    };

    Game_Interpreter.prototype.isEroStatusCommand = function() {
        var script = this.currentCommand().parameters[0];
        return script.contains('$gameSystem.callEroStatus()');
    };

    var _Scene_Map_prototype_createMenuButton = Scene_Map.prototype.createMenuButton;
    Scene_Map.prototype.createMenuButton = function() {
        _Scene_Map_prototype_createMenuButton.call(this);
        // メニューボタンを押したときの処理を上書き
        this._menuButton.setClickHandler(this.commandMenu.bind(this));
    };

    Scene_Map.prototype.commandMenu = function() {
        if (Input.isTriggered('ok') || Input.isTriggered('cancel')) {
            // 右クリックまたはスペースキーでエロステータス画面の表示/非表示
            if ($gameSystem.isEroStatusActive()) {
                $gameSystem.setEroStatusActive(false);
                this.popScene();
            } else {
                $gameSystem.setEroStatusActive(true);
                SceneManager.push(Scene_EroStatus);
            }
        } else {
            // メニュー表示
            SceneManager.push(Scene_Menu);
        }
    };

    Game_System.prototype.isEroStatusActive = function() {
        return this._isEroStatusActive || false;
    };

    Game_System.prototype.setEroStatusActive = function(active) {
        this._isEroStatusActive = active;
    };

    Game_System.prototype.callEroStatus = function() {
        $gameSystem.setEroStatusActive(true);
        SceneManager.push(Scene_EroStatus);
    };
})();